import {
  BRAND_LOGO,
  BRAND_LOGO_DARK,
  BRAND_LOGO_ROUNDED,
} from "constants/config";
import { useSettings } from "contexts/settings/settings.context";

/* eslint-disable @next/next/no-img-element */
export const BrandLogo = () => {
  const { settings } = useSettings();
  return (
    <img
      src={settings?.logo || BRAND_LOGO}
      width="129"
      height="28"
      alt="Brand logo"
    />
  );
};

export const BrandLogoDark = () => {
  const { settings } = useSettings();
  return (
    <img
      src={settings?.dark_logo || BRAND_LOGO_DARK}
      width="129"
      height="28"
      alt="Brand logo dark"
    />
  );
};

export const DoubleCheckIcon = () => (
  <svg
    width="30"
    height="30"
    viewBox="0 0 30 30"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <circle cx="15" cy="15" r="15" fill="#83EA00" />
    <g clipPath="url(#clip0_109_101)">
      <path
        d="M14.668 16.4666L15.8447 17.6433L22.8997 10.5883L24.078 11.7666L15.8447 19.9999L10.5413 14.6966L11.7197 13.5183L13.4905 15.2891L14.668 16.4658V16.4666ZM14.6697 14.1099L18.7963 9.98242L19.9713 11.1574L15.8447 15.2849L14.6697 14.1099ZM12.3138 18.8224L11.1363 19.9999L5.83301 14.6966L7.01134 13.5183L8.18884 14.6958L8.18801 14.6966L12.3138 18.8224Z"
        fill="black"
      />
    </g>
    <defs>
      <clipPath id="clip0_109_101">
        <rect width="20" height="20" fill="white" transform="translate(5 5)" />
      </clipPath>
    </defs>
  </svg>
);

export const BrandLogoRounded = () => (
  <img
    src={BRAND_LOGO_ROUNDED}
    width="60"
    height="60"
    alt="Brand logo rounded"
  />
);

export const LocationIcon = (props: any) => (
  <svg
    width="16"
    height="16"
    viewBox="0 0 16 16"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <path
      d="M10 7C10 7.53043 9.78929 8.03914 9.41421 8.41421C9.03914 8.78929 8.53043 9 8 9C7.46957 9 6.96086 8.78929 6.58579 8.41421C6.21071 8.03914 6 7.53043 6 7C6 6.46957 6.21071 5.96086 6.58579 5.58579C6.96086 5.21071 7.46957 5 8 5C8.53043 5 9.03914 5.21071 9.41421 5.58579C9.78929 5.96086 10 6.46957 10 7Z"
      stroke="white"
      strokeWidth="0.8"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M13 7C13 11.7613 8 14.5 8 14.5C8 14.5 3 11.7613 3 7C3 5.67392 3.52678 4.40215 4.46447 3.46447C5.40215 2.52678 6.67392 2 8 2C9.32608 2 10.5979 2.52678 11.5355 3.46447C12.4732 4.40215 13 5.67392 13 7Z"
      stroke="white"
      strokeWidth="0.8"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
);

export const GlobeIcon = (props: any) => (
  <svg
    width="16"
    height="16"
    viewBox="0 0 16 16"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <path
      d="M13.9286 8.92862L13.172 8.17195C13.0581 8.05786 12.9633 7.92618 12.8913 7.78195L12.1713 6.34195C12.1517 6.30287 12.1231 6.269 12.0878 6.24314C12.0526 6.21728 12.0117 6.20016 11.9685 6.19319C11.9254 6.18622 11.8812 6.18961 11.8396 6.20307C11.798 6.21654 11.7602 6.23969 11.7293 6.27062C11.6597 6.3401 11.5729 6.38972 11.4777 6.41434C11.3825 6.43895 11.2825 6.43767 11.188 6.41062L10.3393 6.16862C10.2035 6.13045 10.0586 6.14189 9.93045 6.20091C9.80235 6.25992 9.69945 6.36265 9.64022 6.49066C9.58099 6.61866 9.5693 6.76359 9.60725 6.89943C9.6452 7.03528 9.73029 7.15317 9.84729 7.23195L10.2386 7.49195C10.632 7.75529 10.688 8.31195 10.3533 8.64662L10.22 8.77995C10.0786 8.92129 9.99995 9.11195 9.99995 9.31062V9.58395C9.99995 9.85662 9.92662 10.1233 9.78662 10.356L8.90995 11.8166C8.78498 12.0251 8.60815 12.1976 8.39668 12.3173C8.1852 12.4371 7.94631 12.5 7.70329 12.5C7.51675 12.5 7.33785 12.4259 7.20595 12.294C7.07405 12.1621 6.99995 11.9832 6.99995 11.7966V11.0153C6.99995 10.402 6.62662 9.85062 6.05729 9.62262L5.62062 9.44862C5.30291 9.32144 5.03824 9.08945 4.87054 8.79114C4.70283 8.49283 4.64217 8.14615 4.69862 7.80862L4.70329 7.78062C4.73428 7.59516 4.79986 7.41718 4.89662 7.25595L4.95662 7.15595C5.11583 6.89083 5.3531 6.68139 5.63594 6.55632C5.91878 6.43125 6.23336 6.39666 6.53662 6.45729L7.32195 6.61462C7.50676 6.65148 7.69867 6.61742 7.85951 6.51922C8.02034 6.42101 8.13832 6.26585 8.18995 6.08462L8.32862 5.59795C8.37666 5.42982 8.36444 5.25019 8.29408 5.09012C8.22372 4.93004 8.09964 4.79958 7.94329 4.72129L7.49995 4.49995L7.43929 4.56062C7.3 4.69991 7.13464 4.8104 6.95265 4.88578C6.77066 4.96116 6.5756 4.99995 6.37862 4.99995H6.25862C6.09262 4.99995 5.93395 5.06662 5.81729 5.18262C5.71036 5.29051 5.56759 5.35545 5.416 5.36513C5.26441 5.37481 5.11454 5.32857 4.99475 5.23516C4.87497 5.14175 4.7936 5.00766 4.76606 4.85828C4.73851 4.7089 4.7667 4.55461 4.84529 4.42462L5.78595 2.85595C5.87971 2.70002 5.94432 2.52834 5.97662 2.34929M13.9286 8.92862C14.0901 7.90004 13.9811 6.84715 13.6125 5.87344C13.2438 4.89972 12.6281 4.03871 11.8258 3.37503C11.0236 2.71134 10.0625 2.26784 9.03694 2.08812C8.01139 1.90839 6.95673 1.99863 5.97662 2.34995C4.9795 2.70738 4.09477 3.3224 3.41235 4.13252C2.72993 4.94265 2.27414 5.91899 2.09129 6.96233C1.90844 8.00568 2.00506 9.07883 2.37133 10.0727C2.7376 11.0666 3.36046 11.9459 4.17661 12.6211C4.99276 13.2963 5.97311 13.7434 7.01804 13.9169C8.06297 14.0905 9.13522 13.9844 10.1258 13.6093C11.1164 13.2342 11.9901 12.6036 12.658 11.7814C13.326 10.9593 13.7643 9.97505 13.9286 8.92862Z"
      stroke="white"
      strokeWidth="0.8"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
);

export const ArrowDownIcon = (props: any) => (
  <svg
    width="10"
    height="10"
    viewBox="0 0 10 10"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <path
      d="M8.125 3.4375L5 6.5625L1.875 3.4375"
      stroke="white"
      strokeWidth="0.7"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
);

export const CashIcon = (props: any) => (
  <svg
    width="16"
    height="16"
    viewBox="0 0 16 16"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <path
      d="M1 11.2791C4.55707 11.2766 8.09867 11.6871 11.5313 12.4998C12.016 12.6148 12.5 12.3011 12.5 11.863V11.2791M2 3V3.43574C2 3.55131 1.94732 3.66214 1.85355 3.74386C1.75979 3.82558 1.63261 3.87148 1.5 3.87148H1M1 3.87148V3.65361C1 3.29282 1.336 3 1.75 3H13M1 3.87148V9.10039M13 3V3.43574C13 3.67627 13.224 3.87148 13.5 3.87148H14M13 3H13.25C13.664 3 14 3.29282 14 3.65361V9.31826C14 9.67906 13.664 9.97187 13.25 9.97187H13M1 9.10039V9.31826C1 9.49161 1.07902 9.65786 1.21967 9.78044C1.36032 9.90301 1.55109 9.97187 1.75 9.97187H2M1 9.10039H1.5C1.63261 9.10039 1.75979 9.1463 1.85355 9.22802C1.94732 9.30973 2 9.42057 2 9.53613V9.97187M13 9.97187V9.53613C13 9.42057 13.0527 9.30973 13.1464 9.22802C13.2402 9.1463 13.3674 9.10039 13.5 9.10039H14M13 9.97187H2M9.5 6.48594C9.5 6.9482 9.28929 7.39153 8.91421 7.7184C8.53914 8.04527 8.03043 8.22891 7.5 8.22891C6.96957 8.22891 6.46086 8.04527 6.08579 7.7184C5.71071 7.39153 5.5 6.9482 5.5 6.48594C5.5 6.02367 5.71071 5.58034 6.08579 5.25347C6.46086 4.9266 6.96957 4.74297 7.5 4.74297C8.03043 4.74297 8.53914 4.9266 8.91421 5.25347C9.28929 5.58034 9.5 6.02367 9.5 6.48594ZM11.5 6.48594H11.5053V6.49059H11.5V6.48594ZM3.5 6.48594H3.50533V6.49059H3.5V6.48594Z"
      stroke="white"
      strokeWidth="0.8"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
);

export const LoginIcon = (props: any) => (
  <svg
    width="24"
    height="24"
    viewBox="0 0 24 24"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <path
      d="M8.30774 7.38467V5.07698C8.30774 4.46494 8.55087 3.87797 8.98365 3.44519C9.41642 3.01242 10.0034 2.76929 10.6154 2.76929H19.8462C20.4582 2.76929 21.0452 3.01242 21.478 3.44519C21.9108 3.87797 22.1539 4.46494 22.1539 5.07698V18.9231C22.1539 19.5352 21.9108 20.1221 21.478 20.5549C21.0452 20.9877 20.4582 21.2308 19.8462 21.2308H11.077C9.80255 21.2308 8.30774 20.1976 8.30774 18.9231V16.6154"
      stroke="var(--dark-blue)"
      strokeWidth="1.6"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M13.8462 16.6153L18.4616 11.9999L13.8462 7.38452M1.84619 11.9999H17.5385"
      stroke="var(--dark-blue)"
      strokeWidth="1.6"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
);

export const DeliveryIcon = (props: any) => (
  <svg
    width="20"
    height="20"
    viewBox="0 0 20 20"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <g clipPath="url(#clip0_1_135)">
      <path
        d="M18.4357 12.434C18.4317 11.1572 18.1393 9.89789 17.5803 8.75H18.1955C18.344 8.74997 18.4904 8.71466 18.6226 8.64697C18.7548 8.57928 18.869 8.48115 18.9559 8.36067C19.0427 8.24018 19.0997 8.10078 19.1221 7.95396C19.1445 7.80714 19.1317 7.6571 19.0848 7.51619L18.8763 6.89119C18.8143 6.70441 18.695 6.54192 18.5354 6.42682C18.3757 6.31171 18.1839 6.24984 17.9871 6.25H15.9375V5.69031C15.9375 5.63624 15.9235 5.58309 15.8968 5.53606C15.8701 5.48904 15.8317 5.44976 15.7852 5.42206L15.2209 5.08484C15.2806 4.96084 15.3118 4.8251 15.3125 4.6875C15.3125 4.50208 15.2575 4.32082 15.1545 4.16665C15.0515 4.01248 14.9051 3.89232 14.7338 3.82136C14.5625 3.75041 14.374 3.73184 14.1921 3.76801C14.0102 3.80419 13.8432 3.89348 13.7121 4.02459C13.581 4.1557 13.4917 4.32275 13.4555 4.5046C13.4193 4.68646 13.4379 4.87496 13.5089 5.04627C13.5798 5.21757 13.7 5.36399 13.8542 5.467C14.0083 5.57002 14.1896 5.625 14.375 5.625C14.5088 5.62454 14.6409 5.59515 14.7623 5.53884L15.3125 5.86762V8.125H14.375C14.2921 8.125 14.2126 8.15792 14.154 8.21653C14.0954 8.27513 14.0625 8.35462 14.0625 8.4375C14.0625 8.52038 14.0954 8.59987 14.154 8.65847C14.2126 8.71708 14.2921 8.75 14.375 8.75H15.625V10.1247C15.6247 10.6043 15.502 11.076 15.2686 11.4951L14.7731 12.383C14.4475 12.5813 14.1569 12.832 13.9129 13.125H11.5625C11.3139 13.1247 11.0756 13.0259 10.8999 12.8501C10.7241 12.6744 10.6253 12.4361 10.625 12.1875V11.5625C10.6246 11.1579 10.4666 10.7693 10.1844 10.4794C10.357 10.3718 10.4899 10.2109 10.5628 10.021C10.6358 9.83112 10.6449 9.62264 10.5887 9.42714C10.5325 9.23164 10.4142 9.05978 10.2515 8.93759C10.0889 8.8154 9.89091 8.74955 9.6875 8.75H2.8125C2.56394 8.75027 2.32564 8.84913 2.14989 9.02489C1.97413 9.20064 1.87527 9.43894 1.875 9.6875C1.87593 9.90261 1.95155 10.1107 2.08894 10.2762C1.46967 10.541 0.941681 10.9817 0.570374 11.5436C0.199067 12.1055 0.000754487 12.764 0 13.4375L0 15.3125C0 15.3954 0.032924 15.4749 0.0915291 15.5335C0.150134 15.5921 0.22962 15.625 0.3125 15.625H1.275C1.34958 16.1454 1.6093 16.6214 2.00652 16.9658C2.40373 17.3101 2.9118 17.4997 3.4375 17.4997C3.9632 17.4997 4.47127 17.3101 4.86848 16.9658C5.2657 16.6214 5.52542 16.1454 5.6 15.625H14.4C14.4746 16.1454 14.7343 16.6214 15.1315 16.9658C15.5287 17.3101 16.0368 17.4997 16.5625 17.4997C17.0882 17.4997 17.5963 17.3101 17.9935 16.9658C18.3907 16.6214 18.6504 16.1454 18.725 15.625H19.6875C19.7704 15.625 19.8499 15.5921 19.9085 15.5335C19.9671 15.4749 20 15.3954 20 15.3125C19.9996 14.7404 19.8562 14.1774 19.5831 13.6748C19.3099 13.1721 18.9155 12.7456 18.4357 12.434ZM14.375 5C14.3132 5 14.2528 4.98167 14.2014 4.94733C14.15 4.913 14.1099 4.86419 14.0863 4.80709C14.0626 4.74999 14.0564 4.68715 14.0685 4.62653C14.0806 4.56592 14.1103 4.51023 14.154 4.46653C14.1977 4.42283 14.2534 4.39306 14.314 4.381C14.3747 4.36895 14.4375 4.37514 14.4946 4.39879C14.5517 4.42244 14.6005 4.46249 14.6348 4.51388C14.6692 4.56527 14.6875 4.62569 14.6875 4.6875C14.6874 4.77036 14.6545 4.8498 14.5959 4.90839C14.5373 4.96698 14.4579 4.99993 14.375 5ZM15.9375 6.875H17.9871C18.0526 6.87494 18.1166 6.89555 18.1698 6.9339C18.223 6.97225 18.2627 7.02639 18.2834 7.08862L18.4918 7.71394C18.5075 7.76089 18.5118 7.81089 18.5043 7.85982C18.4969 7.90875 18.4779 7.95521 18.4489 7.99537C18.42 8.03552 18.3819 8.06821 18.3379 8.09075C18.2938 8.11329 18.245 8.12503 18.1955 8.125H15.9375V6.875ZM15.8142 11.7996C16.0996 11.2875 16.2496 10.711 16.25 10.1247V8.75H16.8821C17.4391 9.78567 17.7532 10.9344 17.8009 12.1094C17.1349 11.8466 16.4023 11.8034 15.7101 11.9862L15.8142 11.7996ZM2.8125 9.375H9.6875C9.77038 9.375 9.84987 9.40792 9.90847 9.46653C9.96708 9.52513 10 9.60462 10 9.6875C10 9.77038 9.96708 9.84987 9.90847 9.90847C9.84987 9.96708 9.77038 10 9.6875 10H2.8125C2.72962 10 2.65013 9.96708 2.59153 9.90847C2.53292 9.84987 2.5 9.77038 2.5 9.6875C2.5 9.60462 2.53292 9.52513 2.59153 9.46653C2.65013 9.40792 2.72962 9.375 2.8125 9.375ZM3.4375 16.875C3.07748 16.8745 2.72865 16.7499 2.44978 16.5222C2.17091 16.2945 1.97907 15.9776 1.90659 15.625H4.96841C4.89593 15.9776 4.70409 16.2945 4.42522 16.5222C4.14636 16.7499 3.79752 16.8745 3.4375 16.875ZM0.643438 15C0.720017 14.3125 1.04736 13.6774 1.56285 13.2162C2.07833 12.7549 2.74578 12.4999 3.4375 12.4999C4.12922 12.4999 4.79667 12.7549 5.31215 13.2162C5.82764 13.6774 6.15498 14.3125 6.23156 15H0.643438ZM13.1408 15H6.85916C6.7963 14.2992 6.51952 13.6346 6.06633 13.0964C5.61313 12.5581 5.00543 12.1722 4.32555 11.9909C3.64568 11.8096 2.9265 11.8416 2.26547 12.0827C1.60443 12.3238 1.03349 12.7623 0.63 13.3388C0.655862 12.6111 0.962837 11.9217 1.4864 11.4156C2.00996 10.9096 2.70933 10.6262 3.4375 10.625H9.0625C9.31106 10.6253 9.54935 10.7241 9.72511 10.8999C9.90087 11.0756 9.99973 11.3139 10 11.5625V12.1875C10.0005 12.6018 10.1653 12.9989 10.4582 13.2918C10.7511 13.5847 11.1482 13.7495 11.5625 13.75H13.5045C13.304 14.1394 13.1806 14.5638 13.1408 15ZM16.5625 16.875C16.2025 16.8745 15.8536 16.7499 15.5748 16.5222C15.2959 16.2945 15.1041 15.9776 15.0316 15.625H18.0934C18.0209 15.9776 17.8291 16.2945 17.5502 16.5222C17.2714 16.7499 16.9225 16.8745 16.5625 16.875ZM13.7674 15C13.8443 14.3125 14.1718 13.6774 14.6875 13.2161C15.2031 12.7549 15.8707 12.4999 16.5625 12.4999C17.2543 12.4999 17.9219 12.7549 18.4375 13.2161C18.9532 13.6774 19.2807 14.3125 19.3576 15H13.7674ZM2.8125 8.125H9.6875C9.77038 8.125 9.84987 8.09208 9.90847 8.03347C9.96708 7.97487 10 7.89538 10 7.8125V6.5625C10 6.47962 9.96708 6.40013 9.90847 6.34153C9.84987 6.28292 9.77038 6.25 9.6875 6.25H2.8125C2.72962 6.25 2.65013 6.28292 2.59153 6.34153C2.53292 6.40013 2.5 6.47962 2.5 6.5625V7.8125C2.5 7.89538 2.53292 7.97487 2.59153 8.03347C2.65013 8.09208 2.72962 8.125 2.8125 8.125ZM3.125 6.875H9.375V7.5H3.125V6.875ZM3.75 5.625H8.75C8.83288 5.625 8.91237 5.59208 8.97097 5.53347C9.02958 5.47487 9.0625 5.39538 9.0625 5.3125C9.0625 5.22962 9.02958 5.15013 8.97097 5.09153C8.91237 5.03292 8.83288 5 8.75 5H8.72812C8.65802 4.45013 8.40731 3.93911 8.01535 3.54715C7.62339 3.15519 7.11237 2.90448 6.5625 2.83437V2.8125C6.5625 2.72962 6.52958 2.65013 6.47097 2.59153C6.41237 2.53292 6.33288 2.5 6.25 2.5C6.16712 2.5 6.08763 2.53292 6.02903 2.59153C5.97042 2.65013 5.9375 2.72962 5.9375 2.8125V2.83437C5.38763 2.90448 4.87661 3.15519 4.48465 3.54715C4.09269 3.93911 3.84198 4.45013 3.77187 5H3.75C3.66712 5 3.58763 5.03292 3.52903 5.09153C3.47042 5.15013 3.4375 5.22962 3.4375 5.3125C3.4375 5.39538 3.47042 5.47487 3.52903 5.53347C3.58763 5.59208 3.66712 5.625 3.75 5.625ZM6.25 3.4375C6.6927 3.43823 7.12088 3.59547 7.45885 3.8814C7.79682 4.16733 8.02281 4.56354 8.09688 5H4.40312C4.47719 4.56354 4.70318 4.16733 5.04115 3.8814C5.37912 3.59547 5.8073 3.43823 6.25 3.4375Z"
        fill="var(--dark-blue)"
        stroke="var(--dark-blue)"
        strokeWidth="0.2"
      />
    </g>
    <defs>
      <clipPath id="clip0_1_135">
        <rect width="20" height="20" fill="white" />
      </clipPath>
    </defs>
  </svg>
);

export const BranchIcon = (props: any) => (
  <svg
    width="20"
    height="20"
    viewBox="0 0 20 20"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <path
      d="M10.8004 17.117V11.0266C10.8004 10.8651 10.8646 10.7101 10.9788 10.5959C11.093 10.4817 11.2479 10.4175 11.4094 10.4175H13.8456C14.0071 10.4175 14.162 10.4817 14.2763 10.5959C14.3905 10.7101 14.4546 10.8651 14.4546 11.0266V17.117M10.8004 17.117H1.75409M10.8004 17.117H14.4546M14.4546 17.117H17.4105M16.2818 17.117V7.65574C16.6054 7.46889 16.8818 7.21007 17.0894 6.89932C17.2971 6.58856 17.4304 6.2342 17.4792 5.86366C17.5279 5.49311 17.4908 5.11631 17.3706 4.76243C17.2504 4.40854 17.0504 4.08705 16.786 3.82284L15.8197 2.8573C15.5915 2.6288 15.2819 2.50028 14.9589 2.5H4.20487C3.88193 2.50028 3.57231 2.6288 3.3441 2.8573L2.37856 3.82203C2.11484 4.08654 1.91538 4.40809 1.79556 4.76188C1.67575 5.11566 1.63878 5.49224 1.6875 5.86257C1.73622 6.2329 1.86934 6.5871 2.07659 6.89786C2.28384 7.20861 2.55968 7.46763 2.88285 7.65493M2.88285 17.1162V7.65655C3.3701 7.93751 3.93953 8.04127 4.49457 7.95025C5.04961 7.85922 5.55607 7.57901 5.92806 7.15714C6.15649 7.41654 6.43762 7.62425 6.75269 7.76638C7.06777 7.90851 7.40953 7.98181 7.75518 7.98137C8.48278 7.98137 9.13567 7.66224 9.5823 7.15632C9.81066 7.41588 10.0918 7.62374 10.4068 7.76601C10.7219 7.90828 11.0637 7.98171 11.4094 7.98137C12.137 7.98137 12.7899 7.66224 13.2366 7.15632C13.6086 7.57807 14.1152 7.85812 14.6702 7.949C15.2252 8.03988 15.7946 7.93598 16.2818 7.65493M5.31901 14.68H8.36422C8.52575 14.68 8.68066 14.6158 8.79488 14.5016C8.9091 14.3874 8.97326 14.2325 8.97326 14.071V11.0266C8.97326 10.8651 8.9091 10.7101 8.79488 10.5959C8.68066 10.4817 8.52575 10.4175 8.36422 10.4175H5.31901C5.15749 10.4175 5.00257 10.4817 4.88836 10.5959C4.77414 10.7101 4.70997 10.8651 4.70997 11.0266V14.0718C4.70997 14.4088 4.98282 14.68 5.31901 14.68Z"
      stroke="var(--dark-blue)"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
);

export const PhoneIcon = (props: any) => (
  <svg
    width="22"
    height="22"
    viewBox="0 0 22 22"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M1.375 4.125C1.375 3.39565 1.66473 2.69618 2.18046 2.18046C2.69618 1.66473 3.39565 1.375 4.125 1.375H5.38267C6.171 1.375 6.8585 1.91217 7.05008 2.67667L8.063 6.73108C8.14508 7.05925 8.1285 7.40434 8.01534 7.72312C7.90217 8.04191 7.69746 8.32021 7.42683 8.52317L6.24158 9.41233C6.11783 9.50492 6.09125 9.64058 6.12608 9.735C6.64343 11.1419 7.46038 12.4196 8.52037 13.4796C9.58035 14.5396 10.8581 15.3566 12.265 15.8739C12.3594 15.9087 12.4942 15.8822 12.5877 15.7584L13.4768 14.5732C13.6798 14.3025 13.9581 14.0978 14.2769 13.9847C14.5957 13.8715 14.9408 13.8549 15.2689 13.937L19.3233 14.9499C20.0878 15.1415 20.625 15.829 20.625 16.6182V17.875C20.625 18.6043 20.3353 19.3038 19.8195 19.8195C19.3038 20.3353 18.6043 20.625 17.875 20.625H15.8125C7.83933 20.625 1.375 14.1607 1.375 6.1875V4.125Z"
      fill="#626262"
    />
  </svg>
);

export const MailIcon = (props: any) => (
  <svg
    width="22"
    height="22"
    viewBox="0 0 22 22"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    {...props}
  >
    <path
      d="M1.375 7.94751V15.8125C1.375 16.5419 1.66473 17.2413 2.18046 17.7571C2.69618 18.2728 3.39565 18.5625 4.125 18.5625H17.875C18.6043 18.5625 19.3038 18.2728 19.8195 17.7571C20.3353 17.2413 20.625 16.5419 20.625 15.8125V7.94751L12.441 12.9828C12.0076 13.2494 11.5088 13.3905 11 13.3905C10.4912 13.3905 9.99236 13.2494 9.559 12.9828L1.375 7.94751Z"
      fill="#626262"
    />
    <path
      d="M20.625 6.33233V6.1875C20.625 5.45815 20.3353 4.75868 19.8195 4.24296C19.3038 3.72723 18.6043 3.4375 17.875 3.4375H4.125C3.39565 3.4375 2.69618 3.72723 2.18046 4.24296C1.66473 4.75868 1.375 5.45815 1.375 6.1875V6.33233L10.2795 11.8122C10.4962 11.9455 10.7456 12.0161 11 12.0161C11.2544 12.0161 11.5038 11.9455 11.7205 11.8122L20.625 6.33233Z"
      fill="#626262"
    />
  </svg>
);
